/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.core.advancement.trigger.TriggerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class TemperatureChangedTrigger
extends SimpleCriterionTrigger<Instance> {
    static final ResourceLocation ID = new ResourceLocation("cold_sweat", "temperature");

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext context) {
        JsonArray tempList = json.get("temperature").getAsJsonArray();
        ArrayList<TriggerHelper.TempCondition> conditions = new ArrayList<TriggerHelper.TempCondition>();
        for (JsonElement element : tempList) {
            JsonObject entry = element.getAsJsonObject();
            Temperature.Trait trait = Temperature.Trait.fromID(entry.get("type").getAsString());
            TriggerHelper.getTempValueOrRange(entry).ifLeft(either -> conditions.add(new TriggerHelper.TempCondition(trait, (double)either, (double)either))).ifRight(pair -> conditions.add(new TriggerHelper.TempCondition(trait, (Double)pair.getFirst(), (Double)pair.getSecond())));
        }
        return new Instance(player, conditions);
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, Map<Temperature.Trait, Double> temps) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(temps));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        List<TriggerHelper.TempCondition> conditions;

        public Instance(EntityPredicate.Composite player, List<TriggerHelper.TempCondition> conditions) {
            super(ID, player);
            this.conditions = conditions;
        }

        public boolean matches(Map<Temperature.Trait, Double> temps) {
            for (TriggerHelper.TempCondition condition : this.conditions) {
                double value;
                if (condition.matches(value = temps.get((Object)condition.trait()).doubleValue())) continue;
                return false;
            }
            return true;
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject obj = super.m_7683_(context);
            obj.add("temperature", (JsonElement)TriggerHelper.serializeConditions(this.conditions));
            return obj;
        }
    }
}

